#ifndef __CScrollPanel__
#define __CScrollPanel__

#include "CControlPanel.hpp"
#include "../Listeners/IScrollListener.hpp"

//	===========================================================================

using Exponent::GUI::Controls::CControlPanel;
using Exponent::GUI::Listeners::IScrollListener;

//	===========================================================================

namespace Exponent
{
	namespace GUI
	{
		namespace Controls
		{
			/**
			 * @class CScrollPanel CScrollPanel.hpp
			 * @brief Scrollable control panel
			 *
			 * @date 21/04/2005
			 * @author Paul Chana
			 * @version 1.0.0 Initial version
			 * @version 1.0.1 Added getVirtualArea function
			 * @version 1.0.2 Added resetViewPort function
			 * @version 1.0.3 Updated to new format, fixing standard functionality so that it now works :)
			 * @version 1.0.4 Added child sorting
			 *
			 * @note All contents of this source code are copyright 2005 Exp Digital Uk.\n
			 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy\n
			 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
			 * All content is the Intellectual property of Exp Digital Uk.\n
			 * Certain sections of this code may come from other sources. They are credited where applicable.\n
			 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
			 *
			 * $Id: CScrollPanel.hpp,v 1.5 2007/02/08 21:07:54 paul Exp $
			 */
			class CScrollPanel : public CControlPanel, public IScrollListener
			{
				/** @cond */
				EXPONENT_CLASS_DECLARATION;
				/** @endcond */

//	===========================================================================

			public:

//	===========================================================================

				/**
				 * Construction
				 * @param root The root panel
				 * @param uniqueId The unique panel id
				 * @param area The controls onscreen area (NOT VIRTUAL AREA!!!
				 * @param virtualArea The total virtual area that the scroll panel convers
				 */
				CScrollPanel(IControlRoot *root, const long uniqueId, const CRect &area, const CRect &virtualArea);

				/**
				 * Destruction
				 */
				virtual ~CScrollPanel();

//	===========================================================================

				/**
				 * Draw the control
				 * @param graphics The graphics context to draw with
				 */
				virtual void drawControl(CGraphics &graphics);

				/**
				 * Update (redraw) a control
				 * @param control The control to redraw
				 */
				virtual void updateControl(IControl *control);

				/**
				 * Update an area
				 * @param area The area to update
				 */
				virtual void updateArea(const CRect &area);

//	===========================================================================

				/**
				 * Handle scrolling events
				 * @param event The scrolling event to handle
				 */
				virtual void handleScrollEvent(const CScrollEvent &event);

				/**
				 * Get the virtual area
				 * @retval const CRect & The virtual area
				 */
				const CRect &getVirtualArea() const { return m_virtualArea; }
				
				/**
				 * Set the virtual area
				 * @param virtualArea The new virtual area
				 */
				void setVirtualArea(const CRect &virtualArea);

//	===========================================================================

				/**
				 * Handle left button being clicked
				 * @param event The event to handle
				 */
				virtual void handleLeftButtonDown(CMouseEvent &event);

				/**
				 * Handle left button being released
				 * @param event The event to handle
				 */
				virtual void handleLeftButtonUp(CMouseEvent &event);

				/**
				 * Handle the right button being clicked
				 * @param event The event to handle
				 */
				virtual void handleRightButtonDown(CMouseEvent &event);

				/**
				 * Handle the right button being released
				 * @param event The event to handle
				 */
				virtual void handleRightButtonUp(CMouseEvent &event);

				/**
				 * Handle a double click on the left button
				 * @param event The event to handle
				 */
				virtual void handleDoubleClick(CMouseEvent &event);

				/**
				 * Handle the scroll wheel
				 * @param event The event to handle
				 */
				virtual void handleMouseScroll(CMouseEvent &event);

				/**
				 * Handle the mouse movement
				 * @param event The event to handle
				 */
				virtual void handleMouseMovement(CMouseEvent &event);

				/**
				 * Handle a mouse leaving the root area
				 * @param event The event to handle
				 */
				virtual void handleMouseLeavingArea(CMouseEvent &event);

//	===========================================================================

				/*
				// Handle key down events
				virtual bool handleKeyDown(const CKeyboardEvent &event);
				
				// Handle key up events
				virtual bool handleKeyUp(const CKeyboardEvent &event);

//	===========================================================================

				// Handle a file drop
				virtual void handleFileDrop(const CDropEvent &event);

//	===========================================================================
				
				

//	===========================================================================
				
				// Get window offset

				// Update an area
				virtual void updateArea(const CRect &area);
*/
//	===========================================================================

				/**
				 * Get the window offset of a control
				 * @retval CPoint* The window offset as a new point that you own
				 */
				virtual CPoint getWindowOffset();

				/**
				 * Get the global location of the control
				 * @param control The control to get the location of
				 * @param point The point to store the window position in
				 */
				virtual void getWindowCoordinatesOfControl(IControl *control, CPoint &point);

				/**
				 * Sort the children controls, removing NULL controls
				 */
				void sortChildControls();

//	===========================================================================

			protected:

//	===========================================================================

				CRect m_virtualArea;				/**< The virtual area to be convered */
				CPoint m_viewPointPosition;			/**< The amount of offset that we have to apply, aka the view port top left */
				CPoint m_inverseViewPointPosition;	/**< Negative view point position */
			};
		}
	}
}
#endif	// End of CScrollPanel.hpp